<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasFactory;

    protected $primaryKey = 'Coupon_id'; // Custom primary key

    protected $fillable = [
        'Code',
        'Discount_type',
        'Discount_value',
        'Expiry_date',
        'Usage_limit',
        'Used_count',
        'Status',
    ];

    protected $casts = [
        'Discount_value' => 'float',
        'Usage_limit' => 'integer',
        'Used_count' => 'integer',
        'Expiry_date' => 'datetime',
    ];

    // Enable timestamps if the table has created_at and updated_at columns
    public $timestamps = true;

    
}